/**HEADER********************************************************************
* 
* Copyright (c) 2012 Freescale Semiconductor;
* All Rights Reserved
*
*************************************************************************** 
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************
*
* $FileName: fxlc95000bsp.h$
* $Version : 1.0.0.0$
* $Date    : Feb-24-2012$
*
* Comments:
*
*   This file contains the source functions for functions required to
*   specifically initialize the card.
*
*END************************************************************************/

#include "bsp.h"


#ifndef _fxlc9550bsp_h_
#define _fxlc9550bsp_h_ 1


/*
** Get MQX configuration (also gets user_config.h)
*/
#include "mqx_cnfg.h"

#ifdef __cplusplus
extern "C" {
#endif





/*-----------------------------------------------------------------------*/
/*                      DEFINITIONS
*/



#pragma pack(push)
#pragma pack(1)
typedef struct
{
  
  // Frame overrun error
  
#if (BSP_TIMER == BSP_TIMER_USE_PDB)
  // Requested tick period. 
  volatile uint_32 rtos_requested_tick_period_nsec;
  // The actual tick period.
  volatile uint_32 rtos_actual_tick_period_nsec;
#endif
  
  // Each timer tick period, 10's usec.
  volatile uint_32 rtos_tick_period_10nsec;

  // Current ticks per second.
  // NOTE: rtos_ticks_per_sec is 16 bit meaning that the smallest rtos tick is 15.3usec.
  // 2^16 = 64k,  1/64k = 0.00001525 or 15.3usec.
  volatile uint_16 rtos_ticks_per_sec;  
  
  
} Rtos_timer_struct;
#pragma pack(pop)

extern Rtos_timer_struct fxlc95000_rtos_timer;
inline Rtos_timer_struct* rtos_timer_addr_get(void)
{
  return &fxlc95000_rtos_timer;
}




// Start of digital frame
#define _fxlc95000_sdf_clear_int() { FCSR |= (1 << 0); }  // Clear by writing 1
#define _fxlc95000_sdf_unmask_int() { FCSR |= 0x02; }     // SFDIE=1, enable PhiD irq.
#define _fxlc95000_sdf_mask_int() { FCSR &= ~0x02; }      // SFDIE=0, disable PhiD irq.

#define _fxlc95000_frameerror_clear_int() {FCSR |= (1 << 2); }        // Clear FE bit
#define _fxlc95000_frameerror_unmask_int() {FCSR |= (3 << 3); }       // SFEIE = 3, Error check in normal/debug
                                                                                // SFEIE = 2, Error check when NOT in BDM mode 
#define _fxlc95000_frameerror_mask_int() {FCSR &= ~(3 << 3); }        // SFEIE = 0, no error checking


extern boolean _fxl95000_GetFrameOverrun_Status(void);
extern void _fxl95000_SetFrameOverrun_Status(boolean newstatus);
#define _fxl95000_ClearFrameOverrun_Status()  { _fxl95000_SetFrameOverrun_Status(FALSE); }


#ifdef DEBUG_ENABLE_STARTOFFRAME_GPIO_TOGGLE
extern void _fxl95000_DebugToggle_StartDigFrame(uint_8 toggle);
#endif


#ifdef DEBUG_ENABLE_FRAMEERROR_GPIO_TOGGLE
extern void _fxl95000_DebugToggle_FrameError(void);
#endif











#ifdef __cplusplus
}
#endif

#endif // EOF, _fxlc9550bsp_h_









